package pl.extern.drools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import pl.extern.drools.Bread;

public class main {

	/**
	 * @param args
	 */
	public static final void main(String[] args)
	{		
		DroolsEngine droolsEngine = new DroolsEngine();
		try
		{
			List myList = new ArrayList ();                        					//zewntrzny parametr do ktrego bd pisaly reguy
			//droolsEngine.addRuleFromDrlFile("bin/reguly.drl");					//ustawianie pamici regu z pliku typu drl			
			droolsEngine.addRuleFromXlsFile("bin/reguly.xls");						//ustalamy i dodajemy reguy biznesowe zapisane w pliku xls
			
			Bread bread = new Bread("PszennyPeny",100,2,50,Bread.Kinds.PSZENNY);  //obiekt faktw
			Milk milk = new Milk("BiaePuszyste",200,3,2,2);						//drugi obiekt faktw
			
			droolsEngine.addFact(bread);											//dodajemy pierwszy obiekt faktw
			droolsEngine.addFact(milk);												//dodajemy drugi obiekt jaktw		
			droolsEngine.addGlobalVariable("myList", myList);						//ustawiamy referencj obiektu globalnego do ktrego bd pisay reguy
			droolsEngine.runRules();												//uruchamiamy reguly na obiektach faktw
			
			//Teraz nastpuje sprawdzamie w jakim stanie s obiekty po przejciu przez reguy biznesowe
			System.out.println(bread.getDescription());
			System.out.println(milk.getDescription());
			//Teraz sprawdzimy jaka jest zawartos obiektu globalnego do ktrego pisay reguy w trakcie przetwarzania
			for(Iterator it = myList.iterator();it.hasNext();)
			{
				String s = (String)it.next();
				System.out.println(s);
			}
		}
		catch(Exception ex)
		{
			System.out.println(ex.getMessage());
		}
	}
}