package pl.extern.drools;

import java.sql.Timestamp;
import java.util.Calendar;
/**
 * Klasa  bazowa dla klas produktw ktre bd przetwarzane przez mechanizm regu, 
 * inaczej mwic podstawa dla klas faktw
 * @author andrzejza
 *
 */
public class Product 
{
	protected String name;
	protected int amount;
	protected float onePrice;
	protected Timestamp usefulness;
	public Product()
	{
		name = "";
		amount = 0;
		onePrice = 0;
		Calendar calendar = Calendar.getInstance();
		usefulness = new Timestamp(calendar.getTimeInMillis());		
	}
	public Product(String aName,int aAmount,float aOnePrice)
	{
		amount = aAmount;
		onePrice = aOnePrice;
	}
	public int getAmount()
	{
		return amount;
	}
	public float getPrice()
	{
		return onePrice;
	}
	public void setPrice(float aOnePrice)
	{
		onePrice = aOnePrice;
	}
	public void setUsefulness(Timestamp auseFulness)
	{
		usefulness = auseFulness;
	}
	public float getAllPrice()
	{
		return amount*onePrice;
	}
	public String getDescription()
	{
		return "name: "+name+"Amount: "+amount+" one price: "+onePrice+" all price:"+getAllPrice();
	}
}
