package pl.extern.drools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

import javax.rules.RuleException;

import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.rule.Package;

public class DroolsEngine 
{
	private StatefulSession session;
	private PackageBuilder builder;
	private Package pkg;
	private RuleBase ruleBase;
//	private InputStreamReader inputStreamReader;
	
//	WorkingMemory workingMemory;
	/**
	 * Konstuktor obiektu DroolsEngine
	 * Tworzy obiekty potrzebne do przetworzenia regu
	 */
	public DroolsEngine()
	{
		builder = new PackageBuilder();		
		ruleBase = RuleBaseFactory.newRuleBase();		
		session = ruleBase.newStatefulSession();
		
	//	workingMemory = ruleBase.newStatefulSession();
		//session.setGlobal(outParamName, outParamRef);  
		//session.insert(object);
		//session.execute(facts);  			
		//session.dispose();
	}
	/**
	 * Metoda klasy DroolsEngine dodaje reguy do pamici regu na podstawie ich zapisu w pliku tekstowym "drl"
	 * @param rulesFileName cieka do pliku drl z reguami (pewno bdzie pobierane z parametrw) 
	 * @throws RuleException
	 */
	public void addRuleFromDrlFile(String rulesFileName) throws RuleException
	{
		try
		{		
			//InputStreamReader inputStreamReader = new InputStreamReader(DroolsEngine.class.getResourceAsStream(rulesFileName));
			Reader inputStreamReader = new FileReader(rulesFileName);
			File file = new File(rulesFileName);
		//	if(file.exists())
//				System.out.println(rulesFileName+" jest plik.");
	//		System.out.println(file.getCanonicalPath());
//			BufferedReader br = new BufferedReader(inputStreamReader);
	//		String s;
//			while((s = br.readLine()) != null)
//				System.out.println(s);
			builder.addPackageFromDrl(inputStreamReader);
			pkg = builder.getPackage();
			ruleBase.addPackage(pkg);
		}
		catch(Exception ex)
		{
			throw new RuleException("Bd tworzenia regu "+ex.getMessage());
		}		
	}
	/**
	 * Metoda klasy DroolsEngine dodaje reguy do pamici regu na podstawie ich zapisu w pliku typu Excel "xls" zapisanym w specyficzy sposb
	 * @param rulesXlsFileName cieka do pliku xls z reguami 
	 * @throws DroolsParserException
	 * @throws IOException
	 */
	public void addRuleFromXlsFile(String rulesXlsFileName) throws DroolsParserException, IOException
	{
		SpreadsheetCompiler spreadsheetCompiler = new SpreadsheetCompiler();
//		InputStream inputStreamReader = DroolsEngine.class.getResourceAsStream(rulesXlsFileName);
		//InputStream inputStreamReader = DroolsEngine.class.getResourceAsStream(rulesXlsFileName);
		//InputStream inputStreamReader = this.getClass().getResourceAsStream(rulesXlsFileName);
		    
		//Reader inputStreamReader = new FileReader(rulesXlsFileName);
	//	FileInputStream inputStreamReader = new FileInputStream()
		InputStream inputStreamReader = new FileInputStream(rulesXlsFileName);
		//InputStreamReader inputStreamReader = new InputStreamReader(rulesXlsFileName);
		String drlString = spreadsheetCompiler.compile(inputStreamReader, InputType.XLS);
		Reader drlReader = new StringReader(drlString);
		builder.addPackageFromDrl(drlReader);
		pkg = builder.getPackage();
		ruleBase.addPackage(pkg);
	}
	/**
	 * Metoda klasy DroolsEngine dodajca obiekt faktw do pamici faktw
	 * @param <T>
	 * @param obiekt Obiekt dowolnego typu ktry bdzie dodany do pamici faktw
	 */
	public <T> void addFact(T obiekt)
	{
		session.insert(obiekt);
		//workingMemory.assertObject(c);
	}
	/**
	 * Metoda klasy DroolsEngine dodajca obiekt globalny do silnika regu, do tego obiektu 
	 * reguy zdefiniowane w plikach regul bd mogy pisa o ile oczywicie w pliku regu 
	 * zmienna ta zostanie odpowiednio zadeklarowana jako Global w pliku drl lub jako Variables w pliku xls  
	 * @param <T>
	 * @param refName Nazwa referencji pod jak zmienna bdzie wystpowaa w silniku regu (moe by taka sama jak nazwa zmiennej)
	 * @param ref referencja do zmiennej globalnej trzeba ja oczywicie wczeniej zainicjowa
	 */
	public <T> void addGlobalVariable(String refName,T ref)
	{
		session.setGlobal(refName, ref);
	}
	/**
	 * Metoda klasy DroolsEngine uruchamiajaca przetwarzanie regul dzialajacych na obiektach faktw
	 * @return
	 */
	public int runRules()
	{
		return session.fireAllRules();	
	}
}
